﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Core;
using CashierCrisis.Entities;


namespace CashierCrisis.Behaviors
{
    public class InitializeBehavior : IVisitor
    {
        private Entity entity;

        public InitializeBehavior(Entity entity)
        {
            this.entity = entity;
        }


        #region IVisitor Members

        public void Visit(IVisitable visitable)
        {
            if (visitable !=null)
            {
                Action behavior = visitable as Action;
                behavior.Entity = entity;
            }
        }

        #endregion
    }
}
